/******************************************************************************\
**
**     COMPANY:	LDW Software
**
**      MODULE:	Editor
**
** DESCRIPTION:	Handles in-game editors
**
**      AUTHOR:	Adrian Francis
**
\******************************************************************************/

#ifndef EDITOR_H
#define EDITOR_H

/******************************************************************************\
** LIBRARY INCLUDES
\******************************************************************************/
#include "ldwTypes.h"
#include "EditorInterface.h"

/******************************************************************************\
** CONSTANT DEFINITIONS
\******************************************************************************/

/******************************************************************************\
** CLASS DEFINITIONS
\******************************************************************************/
class CEditor
{
private:

	//class data
	IEditor *	m_pCurrentEditor;

	//class methods
	//setup
	public:		CEditor(void);
	public:		void Reset();

	// process
	public:		void Draw();
	public:		const bool HandleKeyCharacter(const char cKey);
	public:		const bool HandleKeyDown(const int iKeyCode);
	public:		const bool HandleKeyUp(const int iKeyCode);
	public:		const bool HandleMouseDown(const ldwPoint sMousePos);
	public:		const bool HandleMouseUp(const ldwPoint sMousePos);
	public:		const bool HandleMouseMove(const ldwPoint sMousePos);

	// access
	public:		const bool IsActive() const { return m_pCurrentEditor != 0; }
};

/******************************************************************************\
** GLOBAL DECLARATIONS
\******************************************************************************/
extern CEditor		Editor;

#endif

/******************************************************************************\
** END OF FILE
\******************************************************************************/